@props(["disabled" => false, "size" => ""])

@php
    $sizeClasses = match ($size) {
        "xs" => "text-xs",
        "sm" => "text-sm",
        default => "text-base",
    };

    $attributes = $attributes->merge(["class" => "$sizeClasses"]);
@endphp

<input {{ $disabled ? "disabled" : "" }} {!! $attributes->merge(["class" => "border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 disabled:bg-gray-100 disabled:dark:bg-gray-700 rounded-md shadow-sm"]) !!} />
