<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::table('pages', function (Blueprint $table) {
            $table->boolean('is_published')->after('lang')->default(true);
        });
        Schema::table('posts', function (Blueprint $table) {
            $table->boolean('is_published')->after('lang')->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::table('pages', function (Blueprint $table) {
            $table->dropColumn([
                'is_published',
            ]);
        });
        Schema::table('posts', function (Blueprint $table) {
            $table->dropColumn([
                'is_published',
            ]);
        });
    }
};
